/** @file   MusicControlObject.cpp
 * @brief   Declaration of HotSpot class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/05/15 19:23:42 $
 * @author  Tomi Lamminsaari
 */
 
#include "MusicControlObject.h"
#include "MMp3PlayerProvider.h"

namespace WeWantWar {

MusicControlObject::MusicControlObject( MMp3PlayerProvider& aProvider ) :
  GameObject(),
  iProvider( aProvider ),
  iCurrentVolume( 128 ),
  iVolumeChangePerStep( 0 ),
  iUpdatesToGo( 0 )
{
}

MusicControlObject::~MusicControlObject()
{
}

void MusicControlObject::update()
{
  if ( iUpdatesToGo > 0 ) {
    iCurrentVolume += iVolumeChangePerStep;
    iProvider.setMp3Volume( static_cast<int>(iCurrentVolume) );
    iUpdatesToGo--;
  }
}

void MusicControlObject::redraw( RedrawQueue* aQueue )
{
}

bool MusicControlObject::hitByBullet( Bullet* aBullet )
{
  return false;
}

void MusicControlObject::kill()
{
}

void MusicControlObject::makeSound( GameObject::SoundID aSoundId ) const
{
}

ObjectID::Type MusicControlObject::objectType() const
{
  return ObjectID::TYPE_MUSICCONTROLOBJECT;
}

bool MusicControlObject::reloading() const
{
  return false;
}

void MusicControlObject::launchVolumeFade( int aToVolume, int aDuration )
{
  iUpdatesToGo = aDuration;
  iVolumeChangePerStep = static_cast<float>(aToVolume) - iCurrentVolume;
  iVolumeChangePerStep /= static_cast<float>(aDuration);
}

void MusicControlObject::launchSetVolume( int aVolume )
{
  iUpdatesToGo = 0;
  iCurrentVolume = aVolume;
  iVolumeChangePerStep = 0;
  iProvider.setMp3Volume( aVolume );
}

void MusicControlObject::launchChangeSong( int aSongIndex )
{
  iProvider.playMp3File( aSongIndex );
}

void MusicControlObject::launchStopSong()
{
  iProvider.playMp3File( -1 );
}

}
